//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Sign and create Signed PKCS-7 message with TimeStamp
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
#define PKCS7S_FILE  "pkcs7_tsp.bin"
#define TSP_REP_FILE "tsp_rep.bin"
//------------------------------------------------------------------------------
//         
// :
// 1.      
//------------------------------------------------------------------------------
unsigned char WBuf[8196];
char *Data_for_sign=(char*)"1234567890ABCD";
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTHASH hHash;
 DWORD len,sz;

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //  TimeStamp
 if (getFileLen(TSP_REP_FILE,    &sz)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (TSP_REP_FILE,WBuf,sz)) {printf("readFile error\r\n");   return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,(char*)CSP_PROF,0,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //  -
 if (!CPCreateHash(hProv,CALG_TGR3411,0,0,&hHash)) {
   printf("CPCreateHash Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 if (!CPHashData(hProv,hHash,(BYTE*)Data_for_sign,strlen(Data_for_sign),0)) {
   printf("CPHashData Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //    TIMESTAMP
 if (!CPSetHashParam(hProv,hHash,HP_PKCS9_CUR_OID,(BYTE*)OID_PKCS9_TIMESTAMPATTR,0)) {
   printf("CPSetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 len=sz;
 if (!CPSetHashParam(hProv,hHash,HP_PKCS9U_SIZE,(BYTE*)&len,0)) {
   printf("CPSetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 if (!CPSetHashParam(hProv,hHash,HP_PKCS9U_DATA,WBuf,0)) {
   printf("CPSetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  PKCS7
 len=sizeof(WBuf);
 if (!CPSignHash(hProv,hHash,AT_SIGNATURE,NULL,CRYPT_SIGN_PKCS7,WBuf,&len)) {
   printf("CPSignHash Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 writeFile(PKCS7S_FILE,WBuf,len);
 CPDestroyHash(hProv,hHash);
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
